/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.printing;

import com.genexus.printing.ParseINI;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;

public class Printer
extends Applet {
    private static int BUFFER = 2048;
    private static String tempDirectory;
    private String baseUrl;
    private ArrayList<String> tempFiles;
    private boolean isReady;
    private Logger log;
    private static Boolean isWindows;
    private String printerToUse;
    Hashtable printers = new Hashtable();
    private final int[] BYTE_ORDER_MARK = new int[]{239, 187, 191};
    boolean firstTime = true;
    boolean firstTimeGXR = true;
    Dialog m_Frame;
    Frame m_Frame1;
    CheckboxGroup cg1 = new CheckboxGroup();
    Checkbox deafultPrinter;
    Checkbox otherPrinter = new Checkbox("Other printer:", this.cg1, false);
    SelectOtherPrinter sl = new SelectOtherPrinter(this);
    Choice ch = new Choice();
    Dialog m_Frame2;
    String selectedPrinter = "";

    private static native boolean GxPrintDoc(String var0, String var1);

    private static native boolean GxIsAlive();

    private static native boolean GxShutdown();

    public static boolean isWindows() {
        if (isWindows == null) {
            isWindows = new Boolean(System.getProperty("os.name", "NONE").toLowerCase().indexOf("windows") >= 0);
        }
        return isWindows;
    }

    private static String getTempDirectory() {
        if (tempDirectory == null) {
            try {
                File file = File.createTempFile("test_temp_dir", "");
                tempDirectory = file.getParent();
                file.delete();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return tempDirectory;
    }

    private static void waitReportBuilderToEnd() throws InterruptedException {
        while (Printer.GxIsAlive()) {
            Thread.sleep(100L);
        }
    }

    private static void cleanupReportBuilder() {
        Printer.GxShutdown();
    }

    private void addTempFile(String string) {
        this.log("Appending file to delete: " + string);
        this.tempFiles.add(string);
    }

    private void deleteTempFiles() {
        for (String string : this.tempFiles) {
            this.log("Deleting: " + string);
            if (new File(string).delete()) continue;
            new File(string).deleteOnExit();
        }
        this.tempFiles.clear();
    }

    private String getBaseUrl() {
        if (this.baseUrl == null) {
            this.baseUrl = this.getParameter("path");
        }
        return this.baseUrl;
    }

    private void getFileFromServer(String string) {
        this.getFileFromServer(string, true);
    }

    private void getFileFromServer(String string, boolean bl) {
        try {
            this.log("Getting " + string + " from server");
            String string2 = string;
            if (string.indexOf(":") < 0) {
                string = string.replace(File.separatorChar, '/');
                string2 = this.getBaseUrl() + (string.startsWith("/") ? string : "/" + string);
            }
            this.log("File url = " + string2);
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            Thread.sleep(1000L);
            final DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            final String string3 = Printer.getTempDirectory() + File.separator + this.fileNameFromUrl(string2);
            if (bl) {
                this.addTempFile(string3);
            }
            AccessController.doPrivileged(new PrivilegedAction(){
                int count = -1;
                byte[] bytes = new byte[Printer.access$000()];

                public Object run() {
                    try {
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3), BUFFER);
                        while ((this.count = dataInputStream.read(this.bytes, 0, BUFFER)) > 0) {
                            bufferedOutputStream.write(this.bytes, 0, this.count);
                        }
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return null;
                }
            });
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            this.log("Error getting " + string + " from server", throwable);
        }
    }

    private String fileNameFromUrl(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(File.separator)) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void loadRbuilder() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Printer.this.getReportBuilderLibraries();
                    Printer.this.log("Loading report builder libraries");
                    System.load(Printer.getTempDirectory() + "\\gxdib32.dll");
                    System.load(Printer.getTempDirectory() + "\\rbuilder.dll");
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            this.log("Error initializing applet", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startsWithBOM(File file) throws IOException {
        boolean bl = false;
        if (file.length() < (long)this.BYTE_ORDER_MARK.length) {
            return false;
        }
        int[] nArray = new int[this.BYTE_ORDER_MARK.length];
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            for (int i = 0; i < this.BYTE_ORDER_MARK.length; ++i) {
                nArray[i] = inputStream.read();
            }
            bl = Arrays.equals(nArray, this.BYTE_ORDER_MARK);
        }
        finally {
            inputStream.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripBomFrom(String string) throws IOException {
        File file = new File(string);
        long l = file.length();
        long l2 = l - (long)this.BYTE_ORDER_MARK.length;
        byte[] byArray = new byte[(int)l2];
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            inputStream.skip(this.BYTE_ORDER_MARK.length);
            int n = 0;
            while ((long)n < l2) {
                int n2 = (int)l2 - n;
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 <= 0) continue;
                n += n3;
            }
            this.overwriteWithoutBOM(byArray, file);
        }
        finally {
            inputStream.close();
        }
        File file2 = new File(string);
        long l3 = file2.length();
        long l4 = l - l3;
        if (l4 != (long)this.BYTE_ORDER_MARK.length) {
            throw new RuntimeException("Change in file size: " + l4 + " Expected change: " + this.BYTE_ORDER_MARK.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overwriteWithoutBOM(byte[] byArray, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(byArray);
        }
        finally {
            outputStream.close();
        }
    }

    private void getReportBuilderLibraries() {
        this.log("Getting report builder libraries from server");
        this.getFileFromServer("printingappletsigned.jar");
        try {
            ZipEntry zipEntry;
            this.log("Unzipping report builder libraries");
            final ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(Printer.getTempDirectory() + "\\printingappletsigned.jar")));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (string.endsWith("dll")) {
                    final String string2 = Printer.getTempDirectory() + "\\" + zipEntry.getName();
                    this.addTempFile(string2);
                    AccessController.doPrivileged(new PrivilegedAction(){
                        int count = -1;
                        byte[] bytes = new byte[Printer.access$000()];

                        public Object run() {
                            try {
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2), BUFFER);
                                while ((this.count = zipInputStream.read(this.bytes, 0, BUFFER)) > 0) {
                                    bufferedOutputStream.write(this.bytes, 0, this.count);
                                }
                                bufferedOutputStream.flush();
                                bufferedOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            return null;
                        }
                    });
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Throwable throwable) {
            this.log("Error storing report builder libraries", throwable);
        }
    }

    private boolean fileExists(final String string) {
        final boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                blArray[0] = new File(string).exists();
                return null;
            }
        });
        return blArray[0];
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean printReport(String string) {
        return this.printReport(string, "", "");
    }

    public boolean printReport(String string, String string2, String string3) {
        this.log("Printing report " + string);
        try {
            boolean bl;
            boolean bl2 = bl = string3 != null && !string3.equals("");
            if (bl && !this.fileExists(Printer.getTempDirectory() + File.separator + this.fileNameFromUrl(string3))) {
                this.getFileFromServer(string3, false);
            }
            this.getFileFromServer(string);
            String string4 = Printer.getTempDirectory();
            String string5 = string4 + File.separator + this.fileNameFromUrl(string);
            if (string5.endsWith(".txt")) {
                boolean bl3;
                if (this.firstTime) {
                    this.initPrinterDialog(string2);
                    this.firstTime = false;
                }
                this.printerToUse = "##GXDefaultPrinter##";
                boolean bl4 = bl3 = string2 != null && !string2.equals("");
                if (bl3 && this.mustShowPrinterDialog(string2, string3)) {
                    this.showPrinterDialog(string2);
                    this.updateINIFile(string2, string3);
                }
                final PrintService printService = (PrintService)this.printers.get(this.printerToUse);
                final String string6 = string5;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Printer.this.printDoc(string6, printService);
                        return null;
                    }
                });
            } else if (Printer.isWindows()) {
                if (this.firstTimeGXR) {
                    this.loadRbuilder();
                    this.firstTimeGXR = false;
                }
                String string7 = bl ? string4 : "";
                this.log("Calling report builder dll with (\"" + string5 + "\", \"" + string7 + "\"");
                Printer.GxPrintDoc(string5, string7);
                Printer.waitReportBuilderToEnd();
            }
        }
        catch (Throwable throwable) {
            this.log("Error printing report " + string, throwable);
            return false;
        }
        return true;
    }

    private boolean mustShowPrinterDialog(String string, String string2) {
        if (this.fileExists(Printer.getTempDirectory() + File.separator + this.fileNameFromUrl(string2))) {
            ParseINI parseINI = this.getINIFile(string2);
            if (parseINI.sectionExists(string)) {
                this.printerToUse = parseINI.getProperty(string, "Printer");
                return false;
            }
            return true;
        }
        return true;
    }

    private void updateINIFile(String string, String string2) {
        ParseINI parseINI = this.getINIFile(string2);
        parseINI.setProperty(string, "Printer", this.printerToUse);
        final ParseINI parseINI2 = parseINI;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    parseINI2.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private ParseINI getINIFile(String string) {
        final String string2 = Printer.getTempDirectory() + File.separator + this.fileNameFromUrl(string);
        ParseINI parseINI = AccessController.doPrivileged(new PrivilegedAction<ParseINI>(){

            @Override
            public ParseINI run() {
                try {
                    return new ParseINI(string2);
                }
                catch (IOException iOException) {
                    return new ParseINI();
                }
            }
        });
        return parseINI;
    }

    private String getDefaultPrinter() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null) {
            this.printers.put("##GXDefaultPrinter##", printService);
            return printService.getName();
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        this.printers.put("##GXDefaultPrinter##", printServiceArray[0]);
        return printServiceArray[0].getName();
    }

    private void loadAllPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            this.ch.addItem(printServiceArray[i].getName());
            this.printers.put(printServiceArray[i].getName(), printServiceArray[i]);
        }
    }

    private void printDoc(String string, PrintService printService) {
        if (Printer.isWindows()) {
            try {
                Object object;
                DocFlavor[] docFlavorArray = printService.getSupportedDocFlavors();
                this.log("Supported flavors:");
                for (int i = 0; i < docFlavorArray.length; ++i) {
                    this.log(docFlavorArray[i].toString());
                }
                DocFlavor.INPUT_STREAM iNPUT_STREAM = null;
                if (string.endsWith("txt") && !printService.isDocFlavorSupported(iNPUT_STREAM = DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8) && this.startsWithBOM((File)(object = new File(string)))) {
                    this.log("Strip Byte Order Mark from UTF8 file");
                    this.stripBomFrom(string);
                }
                if (iNPUT_STREAM == null || !printService.isDocFlavorSupported(iNPUT_STREAM)) {
                    iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
                    this.log("Flavor Text Plain UTF8 NOT supported");
                } else {
                    this.log("Flavor Text Plain UTF8 supported!");
                }
                object = new FileInputStream(string);
                DocPrintJob docPrintJob = printService.createPrintJob();
                SimpleDoc simpleDoc = new SimpleDoc(object, iNPUT_STREAM, null);
                docPrintJob.print(simpleDoc, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log("File " + string + " not found: ", fileNotFoundException);
            }
            catch (PrintException printException) {
                this.log("Error printing report " + string, printException);
            }
            catch (Exception exception) {
                this.log("Error printing " + string, exception);
            }
        } else {
            try {
                String[] stringArray = new String[]{"lp", "-d", printService.getName(), string};
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                this.log("Error printing report " + string, exception);
            }
        }
    }

    private void initPrinterDialog(String string) {
        this.m_Frame = new Dialog(this.m_Frame1, "Select Printer", true);
        this.m_Frame.setSize(550, 180);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.m_Frame.getSize();
        this.m_Frame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.m_Frame.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Label label = new Label("The application is trying to print a form named " + string + ". Please select the printer you want this form to be printed on");
        Button button = new Button("Ok");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.m_Frame.add((Component)label, gridBagConstraints);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = Printer.this.getDefaultPrinter();
                return null;
            }
        });
        PrintService printService = (PrintService)this.printers.get("##GXDefaultPrinter##");
        this.deafultPrinter = new Checkbox("Your default printer: " + printService.getName(), this.cg1, true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.m_Frame.add((Component)this.deafultPrinter, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 500;
        gridBagConstraints.anchor = 17;
        this.m_Frame.add((Component)this.otherPrinter, gridBagConstraints);
        this.deafultPrinter.addItemListener(this.sl);
        this.otherPrinter.addItemListener(this.sl);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 40;
        this.m_Frame.add((Component)button, gridBagConstraints);
        button.addActionListener(new GXAction());
        this.m_Frame.pack();
        this.m_Frame.setResizable(false);
        this.m_Frame.addWindowListener(new WPWindowListener());
        this.m_Frame2 = new Dialog(this.m_Frame, "Select Other Printer", true);
        this.m_Frame2.setSize(550, 180);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension4 = this.m_Frame2.getSize();
        this.m_Frame2.setLocation((dimension3.width - dimension4.width) / 2, (dimension3.height - dimension4.height) / 2);
        this.m_Frame2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Printer.this.loadAllPrinters();
                return null;
            }
        });
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.m_Frame2.add((Component)this.ch, gridBagConstraints2);
        Button button2 = new Button("Ok");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.ipadx = 40;
        this.m_Frame2.add((Component)button2, gridBagConstraints2);
        button2.addActionListener(new GXAction1());
        this.m_Frame2.pack();
        this.m_Frame2.setResizable(false);
        this.m_Frame2.addWindowListener(new WPWindowListener());
    }

    private void showPrinterDialog(String string) {
        this.deafultPrinter.setState(true);
        this.cg1.setSelectedCheckbox(this.deafultPrinter);
        this.m_Frame.setVisible(true);
    }

    public void changeOtherPrinterText(ItemEvent itemEvent) {
        if (this.cg1.getSelectedCheckbox().equals(this.otherPrinter)) {
            this.m_Frame2.setVisible(true);
            this.otherPrinter.setLabel("Other printer: " + this.selectedPrinter);
            this.printerToUse = this.selectedPrinter;
        } else {
            this.printerToUse = "##GXDefaultPrinter##";
        }
    }

    private void createLogFile() {
        try {
            String string = this.getLogFileName();
            this.tempFiles.add(string);
            this.log = Logger.getLogger(Printer.class.getName());
            this.log.setLevel(Level.ALL);
            this.log.addHandler(new FileHandler(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private String getLogFileName() {
        return Printer.getTempDirectory() + File.separator + "log" + System.currentTimeMillis() + ".log";
    }

    private void log(String string) {
        this.log.log(Level.ALL, string);
    }

    private void log(String string, Throwable throwable) {
        this.log.log(Level.ALL, string, throwable);
    }

    @Override
    public void init() {
        this.tempFiles = new ArrayList();
        this.setVisible(false);
        this.createLogFile();
    }

    @Override
    public void start() {
        super.start();
        this.isReady = true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.deleteTempFiles();
        if (!this.firstTimeGXR) {
            Printer.cleanupReportBuilder();
        }
    }

    class SelectOtherPrinter
    implements ItemListener {
        private Printer applet;

        public SelectOtherPrinter(Printer printer2) {
            this.applet = printer2;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.applet.changeOtherPrinterText(itemEvent);
        }
    }

    class WPWindowListener
    extends WindowAdapter {
        WPWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }
    }

    class GXAction1
    implements ActionListener {
        GXAction1() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Printer.this.selectedPrinter = Printer.this.ch.getSelectedItem();
            Printer.this.m_Frame2.setVisible(false);
        }
    }

    class GXAction
    implements ActionListener {
        GXAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Printer.this.m_Frame.setVisible(false);
        }
    }
}

