/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.printing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class ParseINI {
    private static final int MAX_LINE_LENGTH = 255;
    private static final byte SECTION_SEPARATOR_CHAR = 38;
    private static final String SECTION_SEPARATOR = "&";
    private static final String GENERAL = "&General&";
    private String entryName;
    private DataInputStream inputStream;
    private Hashtable sections = new Hashtable();
    private Hashtable sectionEntries;
    private Hashtable general;
    private Hashtable aliased = new Hashtable();
    private Hashtable alias = new Hashtable();
    private boolean need2Save = false;
    private String filename = null;
    byte[] tempBytes = new byte[16384];

    public ParseINI() {
        this.general = new Hashtable();
        this.filename = null;
    }

    public ParseINI(String string) throws IOException {
        this.filename = new File(string).getAbsolutePath();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            new FileWriter(string).close();
            this.general = new Hashtable();
        }
    }

    public boolean need2Save() {
        return this.need2Save;
    }

    public void finalize() {
        if (this.need2Save) {
            try {
                this.save();
            }
            catch (IOException iOException) {
                System.out.println("ParseINI (" + this.filename + "):" + iOException);
            }
        }
    }

    public Enumeration sectionNames() {
        return this.sections.keys();
    }

    public boolean sectionExists(String string) {
        return this.sections.containsKey(string);
    }

    public String getGeneralProperty(String string) {
        return this.getProperty(this.general, string, null);
    }

    public boolean setupProperty(String string, String string2, String string3) {
        if (this.getProperty(string, string2) != null) {
            return false;
        }
        this.setProperty(string, string2, string3);
        return true;
    }

    public void setProperty(String string, String string2, String string3) {
        if (!this.sections.containsKey(string)) {
            this.sections.put(string, new Hashtable());
        }
        this.need2Save |= !string3.equals(((Hashtable)this.sections.get(string)).put(string2, string3));
    }

    public String getProperty(String string, String string2) {
        return this.getProperty((Hashtable)this.sections.get(string), string2, null);
    }

    private String getProperty(Hashtable hashtable, String string, String string2) {
        if (hashtable != null && hashtable.containsKey(string)) {
            return (String)hashtable.get(string);
        }
        return string2;
    }

    public void load(InputStream inputStream) throws IOException {
        this.inputStream = new DataInputStream(inputStream);
        this.sectionEntries = new Hashtable();
        this.sections.put(GENERAL, this.sectionEntries);
        try {
            while ((this.entryName = this.readEntryName()) != null) {
                this.sectionEntries.put(this.entryName, this.readEntry());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.general = (Hashtable)this.sections.get(GENERAL);
        this.sections.remove(GENERAL);
    }

    public void save() throws IOException {
        if (this.need2Save && this.filename != null) {
            this.save(new FileOutputStream(this.filename));
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        int n;
        String string;
        String string2;
        Enumeration enumeration;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        if (this.general != null) {
            enumeration = this.general.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = this.getGeneralProperty(string2);
                if (string.equals("")) continue;
                n = string.length() + string2.length() + 4 > 255 ? 255 - string2.length() - 4 : string.length();
                dataOutputStream.writeBytes(string2 + "= " + string.substring(0, n) + "\r\n");
                while (string.length() - n > 251) {
                    dataOutputStream.writeBytes(" " + string.substring(n, n + 251) + "\r\n");
                    n += 251;
                }
                if (n >= string.length()) continue;
                dataOutputStream.writeBytes(" " + string.substring(n) + "\r\n");
            }
        }
        Enumeration enumeration2 = this.sectionNames();
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            dataOutputStream.writeBytes("\r\n[" + string3 + "]\r\n");
            enumeration = ((Hashtable)this.sections.get(string3)).keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = this.getProperty(string3, string2);
                if (string.equals("")) continue;
                n = string.length() + string2.length() + 4 > 255 ? 255 - string2.length() - 4 : string.length();
                dataOutputStream.writeBytes(string2 + "= " + string.substring(0, n) + "\r\n");
                while (string.length() - n > 251) {
                    dataOutputStream.writeBytes(" " + string.substring(n, n + 255 - 4) + "\r\n");
                    n += 251;
                }
                if (n >= string.length()) continue;
                dataOutputStream.writeBytes(" " + string.substring(n) + "\r\n");
            }
        }
        dataOutputStream.close();
        this.need2Save = false;
    }

    private String readEntryName() throws IOException {
        int n = 0;
        block6: while (true) {
            byte by = this.inputStream.readByte();
            switch ((char)by) {
                case '%': 
                case '*': {
                    do {
                        if ((by = this.inputStream.readByte()) == 10) continue block6;
                    } while (by != 13);
                    break;
                }
                case ' ': {
                    if (this.entryName == null) {
                        throw new IOException("Invalid entry");
                    }
                    this.sectionEntries.put(this.entryName, (String)this.sectionEntries.get(this.entryName) + this.readEntry());
                    return this.readEntryName();
                }
                case '[': {
                    this.sectionEntries = new Hashtable();
                    String string = this.readEntry();
                    string = string.substring(0, string.length() - 1);
                    this.sections.put(string, this.sectionEntries);
                    this.entryName = null;
                    return this.readEntryName();
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    this.tempBytes[n++] = by;
                    while ((by = this.inputStream.readByte()) != 58 && by != 61) {
                        this.tempBytes[n++] = by;
                    }
                    if (n == 4 && this.tempBytes[0] == 78 && this.tempBytes[1] == 97 && this.tempBytes[2] == 109 && this.tempBytes[3] == 101) {
                        this.sectionEntries = new Hashtable();
                        String string = this.readEntry();
                        if (string.startsWith("./")) {
                            string = string.substring(2);
                        }
                        this.sections.put(string, this.sectionEntries);
                        this.entryName = null;
                        return this.readEntryName();
                    }
                    return new String(this.tempBytes, 0, n);
                }
            }
        }
    }

    private String readEntry() throws IOException {
        int n = 0;
        byte by = this.inputStream.readByte();
        while (Character.isWhitespace((char)by)) {
            if (by == 0 || by == 10 || by == 13) {
                return "";
            }
            by = this.inputStream.readByte();
        }
        this.tempBytes[n++] = by;
        try {
            while ((by = this.inputStream.readByte()) != 0 && by != 10 && by != 13) {
                this.tempBytes[n++] = by;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new String(this.tempBytes, 0, n);
    }
}

